﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.Business;

public partial class Survey2009 : BasePage
{
    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/Surveys.aspx",
        "/SurveyLink.aspx",
        "/PatientWorkflows.aspx"
    };

    private readonly InstitutionManager _instManager;
    private readonly SurveyManager _manager;

    private WKF_CASE_ACTIVITY _activity;

    public Survey2009()
    {
        _instManager = new InstitutionManager();
        _manager = new SurveyManager();

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            SetRadioDefaults();

            int surveyId;
            if (int.TryParse(Request.QueryString["activityId"], out surveyId))
            {
                getRefreshSurvey(surveyId);

                LoadDropDownData();
                RefreshVAMCListAndSelectInstitution();


                if (_activity.WKF_CASE.STD_WKFCASETYPE_ID == 3)
                {
                    SetupBioSurvey();
                }
                if (_activity.WKF_CASE.STD_WKFCASETYPE_ID == 4)
                    SetupFragmentsSurvey();
            }

            SetReferringPage();
        }

        SetUpFinishButton();

        Page.DataBind();
    }

    protected override void OnLoadComplete(EventArgs e)
    {
        //do not show complete(finish page) for complete questionnaires
        if (_activity.STD_WKFACTIVITYSTS_ID == 2)
        {
            if (FragmentsSurveyWizard.ActiveStep.ID.Equals("FacilityContactPhoneQuestion"))
            {
                Button buttonFirstSave = FragmentsSurveyWizard.FindControl("StepNavigationTemplateContainerID").FindControl("StepNext") as Button;
                if (buttonFirstSave != null)
                {
                    buttonFirstSave.Enabled = false;
                }

            }
            else
            {
                Button buttonFirstSave = FragmentsSurveyWizard.FindControl("StepNavigationTemplateContainerID").FindControl("StepNext") as Button;
                if (buttonFirstSave != null)
                {
                    buttonFirstSave.Enabled = true;
                }

            }
        }

        base.OnLoadComplete(e);
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string activityXml = (string)ViewState["activityXml"];
        _activity = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>(activityXml);

    }

    protected override object SaveViewState()
    {
        ViewState["activityXml"] = _activity.Serialize();
        return base.SaveViewState();


    }

    protected void VAMC_Changed(object sender, EventArgs e)
    {
    }






    private void RefreshVAMCListAndSelectInstitution()
    {
        VAMCFAcilityNamesListBox.Items.Clear();
        VAMCFAcilityNamesListBox.Items.Add(new ListItem("(Please select institution)", "0"));
        VAMCFAcilityNamesListBox.Items.AddRange(DropDownLists.GetInsitutionList().Select(kvp => new ListItem(kvp.Value.Trim(), kvp.Key.ToString())).ToArray());

    }

    private void getRefreshSurvey(int sId)
    {

        _activity = _manager.getSurveyBySurveyID(sId);
        _activity.SetAsChangeTrackingRoot();
    }

    private void SetRadioDefaults()
    {
        BulletInjuryButtonList.SelectedIndex = 2;
        BlastExplosionButtonList.SelectedIndex = 2;
        VehicleInjuryButtonList.SelectedIndex = 2;
        SurgeryButtonList.SelectedIndex = 3;
        FragmentButtonList.SelectedIndex = 3;
        AnalysisButtonList.SelectedIndex = 3;
        OtherForeignMaterialButtonList.SelectedIndex = 2;
        UnrelatedShrapnelButtonList.SelectedIndex = 2;
        UrineCollectionButtonList.SelectedIndex = 2;
    }

    private void SetUpFinishButton()
    {
        switch (_activity.STD_WKFACTIVITYSTS_ID)
        {
            case 6:

                break;

            case 1:

                break;

            case 2:

                if (BiologicalSurveyWizard.Visible == true)
                {

                    Button buttonComplete = BiologicalSurveyWizard.FindControl("FinishNavigationTemplateContainerID").FindControl("StepFinish") as Button;
                    if (buttonComplete != null)
                    {
                        buttonComplete.Text = "Complete Questionnaire";
                        buttonComplete.Click -= CompleteBioSurvey_Click;
                        buttonComplete.Click += SaveBioSurvey_Click;
                    }

                }
                else
                {
                    Button buttonComplete = FragmentsSurveyWizard.FindControl("FinishNavigationTemplateContainerID").FindControl("StepFinish") as Button;
                    if (buttonComplete != null)
                    {
                        buttonComplete.Text = "Complete Questionnaire";
                        buttonComplete.Click -= CompleteFragSurvey_Click;
                        buttonComplete.Click += SaveFragSurvey_Click;
                        buttonComplete.Enabled = true;
                    }

                }
                break;
        }

    }
    private void SetupBioSurvey()
    {
        //set visibility, only show bio questionnaire

        BiologicalSurveyWizard.Visible = true;
        FragmentsSurveyWizard.Visible = false;
        PanelQuestionnaires.GroupingText = "&nbsp;Biological Monitoring Specimen Collection Kit Questionnaire (March 2009 Version)&nbsp;";

        QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT bioKit;

        switch (_activity.STD_WKFACTIVITYSTS_ID)
        {
            case 6:
                CityStateManager addressManager = new CityStateManager();

                //prepopulate new questionnaire
                if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION_ID.HasValue)
                    VAMCFAcilityNamesListBox.SelectedValue = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION_ID.Value.ToString();

                VAMCNameTextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.NAME;

                if (string.IsNullOrEmpty(_activity.WKF_CASE.REFERRAL.ADDRESS_LINE1))
                {
                    if (string.IsNullOrEmpty(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE1))
                    {
                        VAMCAddress1TextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE1;
                        VAMCAddress2TextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE2;
                        VAMCAddress3TextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE3;
                        VAMCCityTextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETCITY;
                        if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETSTATE_ID.HasValue)
                        {
                            VAMCStateTextBox.Text = addressManager.GetStateByID((int)_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETSTATE_ID);
                        }
                        if (!String.IsNullOrEmpty(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETPOSTALCODE))
                        {
                            if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETPOSTALCODE.IndexOf('-') > -1)
                            {
                                var zip = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETPOSTALCODE.Split('-');

                                VAMCZipTextBox.Text = zip[0];
                                VAMCZip4TextBox.Text = zip[1];
                            }
                            else
                            {
                                VAMCZipTextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGPOSTALCODE;
                            }
                        }
                    }
                    else
                    {
                        VAMCAddress1TextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE1;
                        VAMCAddress2TextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE2;
                        VAMCAddress3TextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE3;
                        VAMCCityTextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGCITY;
                        if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGSTATE_ID.HasValue)
                        {
                            VAMCStateTextBox.Text = addressManager.GetStateByID((int)_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGSTATE_ID);
                        }
                        if (!String.IsNullOrEmpty(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGPOSTALCODE))
                        {
                            if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGPOSTALCODE.IndexOf('-') > -1)
                            {
                                var zip = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGPOSTALCODE.Split('-');

                                VAMCZipTextBox.Text = zip[0];
                                VAMCZip4TextBox.Text = zip[1];
                            }
                            else
                            {
                                VAMCZipTextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGPOSTALCODE;
                            }
                        }
                    }
                }
                else
                {
                    VAMCAddress1TextBox.Text = _activity.WKF_CASE.REFERRAL.ADDRESS_LINE1;

                    VAMCAddress2TextBox.Text = _activity.WKF_CASE.REFERRAL.ADDRESS_LINE2;

                    VAMCAddress3TextBox.Text = _activity.WKF_CASE.REFERRAL.ADDRESS_LINE3;

                    VAMCCityTextBox.Text = _activity.WKF_CASE.REFERRAL.CITY;

                    VAMCStateTextBox.Text = _activity.WKF_CASE.REFERRAL.STATE;

                    if (!String.IsNullOrEmpty(_activity.WKF_CASE.REFERRAL.POSTAL_CODE))
                    {
                        if (_activity.WKF_CASE.REFERRAL.POSTAL_CODE.IndexOf('-') > -1)
                        {
                            var zip = _activity.WKF_CASE.REFERRAL.POSTAL_CODE.Split('-');

                            VAMCZipTextBox.Text = zip[0];
                            VAMCZip4TextBox.Text = zip[1];
                        }
                        else
                        {
                            VAMCZipTextBox.Text = _activity.WKF_CASE.REFERRAL.POSTAL_CODE;
                        }
                    }
                }

                break;


            case 1:
                //in-process questionnaire - populate with previously saved data
                if (_activity.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.Count > 0)
                {
                    bioKit = _activity.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.First();

                    SetupSavedOrCompleteSurvey(bioKit);
                    SetupBodyPartsCheckList(bioKit);
                    SetupBodyFragmentsCheckList(bioKit);
                    SetupTreatmentFacilitiesCheckList(bioKit);
                    SetupExplosionCause(bioKit);

                }
                break;


            case 2:
                //completed questionnaire

                if (_activity.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.Count > 0)
                {
                    bioKit = _activity.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.First();

                    SetupSavedOrCompleteSurvey(bioKit);
                    SetupBodyPartsCheckList(bioKit);
                    SetupBodyFragmentsCheckList(bioKit);
                    SetupTreatmentFacilitiesCheckList(bioKit);
                    SetupExplosionCause(bioKit);

                }

                break;
        }
    }

    private void SetupFragmentsSurvey()
    {
        BiologicalSurveyWizard.Visible = false;
        FragmentsSurveyWizard.Visible = true;
        PanelQuestionnaires.GroupingText = "&nbsp;Fragment Collection Kit Form Details&nbsp;";

        QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM fragKit;

        switch (_activity.STD_WKFACTIVITYSTS_ID)
        {
            case 6:

                //VAMCFragFacilityNameTextBox.Text = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.NAME;

                if (_activity.WKF_CASE.REFERRAL != null)
                {
                    //VAMCFragFacilityNameTextBox.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.NAME;
                    if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION_ID.HasValue)
                        VAMCFacilityNameList.SelectedValue = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION_ID.Value.ToString();
                    //VAMCFragAddress1TextBox.Text = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGADDRESSLINE1;
                    VAMCFragAddress1TextBox.Text = _activity.WKF_CASE.REFERRAL.ADDRESS_LINE1;


                    //VAMCFragAddress2TextBox.Text = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGADDRESSLINE2;
                    VAMCFragAddress2TextBox.Text = _activity.WKF_CASE.REFERRAL.ADDRESS_LINE2;

                    //VAMCFragAddress3TextBox.Text = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGADDRESSLINE3;
                    VAMCFragAddress3TextBox.Text = _activity.WKF_CASE.REFERRAL.ADDRESS_LINE3;

                    //VAMCFragCityTextBox.Text = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGCITY;
                    VAMCFragCityTextBox.Text = _activity.WKF_CASE.REFERRAL.CITY;

                    //VAMCFragStateTextBox.Text = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.STD_STATE.POSTALNAME;
                    VAMCFragStateTextBox.Text = _activity.WKF_CASE.REFERRAL.STATE;

                    //VAMCFragZipTextBox.Text = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGPOSTALCODE;

                    //if (!String.IsNullOrEmpty(_activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGPOSTALCODE))
                    if (!String.IsNullOrEmpty(_activity.WKF_CASE.REFERRAL.POSTAL_CODE))
                    {
                        //if (_activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGPOSTALCODE.IndexOf('-') > -1)
                        if (_activity.WKF_CASE.REFERRAL.POSTAL_CODE.IndexOf('-') > -1)
                        {
                            //string[] zip = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGPOSTALCODE.Split('-');

                            var zip = _activity.WKF_CASE.REFERRAL.POSTAL_CODE.Split('-');
                            VAMCFragZipTextBox.Text = zip[0];
                            VAMCFragZip4TextBox.Text = zip[1];
                        }
                        else
                        {
                            //VAMCFragZipTextBox.Text = _activity.WKF_CASE.PATIENT.STD_INSTITUTION.MAILINGPOSTALCODE;
                            VAMCFragZipTextBox.Text = _activity.WKF_CASE.REFERRAL.POSTAL_CODE;
                        }
                    }

                    VAMCFragMailStopTextBox.Text = String.Empty;

                }
                break;

            case 1:

                if (_activity.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs.Count > 0)
                {
                    fragKit = _activity.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs.First();

                    SetupSavedOrCompleteFragSurvey(fragKit);



                }
                break;
            case 2:

                if (_activity.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs.Count > 0)
                {
                    fragKit = _activity.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs.First();

                    SetupSavedOrCompleteFragSurvey(fragKit);

                }

                //FacilityContactPhoneQuestion.StepType = WizardStepType.Finish;  
                //FragmentsSurveyWizard.ActiveStepIndex = 0;
                Button buttonComplete = FragmentsSurveyWizard.FindControl("FinishNavigationTemplateContainerID").FindControl("StepFinish") as Button;
                if (buttonComplete != null)
                {
                    buttonComplete.Enabled = false;
                }

                break;
        }
    }

    protected void BioWizard_StepChanged(object sender, EventArgs e)
    {
        Label label = BiologicalSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
        if (label != null)
        {
            label.Text = String.Empty;
        }
    }

    protected void BioWizard_Next(object sender, WizardNavigationEventArgs e)
    {
        HiddenFieldNextQuesion.Value = "1";
    }


    protected void FragWizard_StepChanged(object sender, EventArgs e)
    {
        //_activity.STD_WKFACTIVITYSTS_ID = 1;
        Label label = FragmentsSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
        if (label != null)
        {
            label.Text = String.Empty;
        }


    }

    protected void FragWizard_Next(object sender, WizardNavigationEventArgs e)
    {
        //_activity.STD_WKFACTIVITYSTS_ID = 2;    

        //SetFocusForNextStep();
        HiddenFieldNextQuesion.Value = "1";
    }

    //private void SetFocusForNextStep()
    //{
    //    for (int i = this.FragmentsSurveyWizard.ActiveStepIndex + 1; 
    //        i < this.FragmentsSurveyWizard.WizardSteps.Count; i++)
    //    {
    //        if(this.FragmentsSurveyWizard.WizardSteps[i].Visible)
    //        {
    //            SetFocusOnTextBox(this.FragmentsSurveyWizard.WizardSteps[i].Controls);
    //        }
    //    }
    //}
    protected override void OnPreRender(EventArgs e)
    {
        //SetFocusOnTextBox(this.Controls);
        base.OnPreRender(e);
    }

    //private void SetFocusOnTextBox(ControlCollection controls)
    //{
    //    for (int i = 0; i < controls.Count; i++)
    //    {
    //        var test1 = controls[i].GetType().Name;
    //        var test2 = controls[i].Visible;
    //        var test3 = controls[i].ID;
    //        if ((controls[i].GetType().Name == "TextBox" ||
    //                controls[i].GetType().Name == "DropDownList" ) &&
    //                    controls[i].Visible)
    //        {
    //            controls[i].Focus();
    //            break;
    //        }

    //        if (controls[i].HasControls())
    //        {
    //            SetFocusOnTextBox(controls[i].Controls);
    //        }
    //    }
    //}


    protected void SaveFragSurvey_Click(object sender, EventArgs e)
    {
        if (_activity.STD_WKFACTIVITYSTS_ID != 2)
        {
            _activity.STD_WKFACTIVITYSTS_ID = 1;

            //FragmentsSurveyWizard.ActiveStepIndex = 0;
        }
        SaveCompleteFragSurvey();


        Label label = FragmentsSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
        if (label != null)
        {
            label.Text = "The form has been saved successfully.";
        }

        SetupFragmentsSurvey();
    }

    protected void CompleteFragSurvey_Click(object sender, EventArgs e)
    {
        _activity.STD_WKFACTIVITYSTS_ID = 2;
        FragmentsSurveyWizard.ActiveStepIndex = 0;

        SaveCompleteFragSurvey();

        Label label = FragmentsSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
        if (label != null)
        {
            label.Text = "The form has been saved and completed successfully.";
        }

        SetupFragmentsSurvey();
    }


    protected void SaveBioSurvey_Click(object sender, EventArgs e)
    {
        if (_activity.STD_WKFACTIVITYSTS_ID != 2)
        {
            _activity.STD_WKFACTIVITYSTS_ID = 1;
        }

        SaveCompleteBioSurvey();


        Label label = BiologicalSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
        if (label != null)
        {
            label.Text = "The form has been saved successfully.";
        }

        SetupBioSurvey();
    }

    protected void CompleteBioSurvey_Click(object sender, EventArgs e)
    {
        _activity.STD_WKFACTIVITYSTS_ID = 2;
        BiologicalSurveyWizard.ActiveStepIndex = 0;

        SaveCompleteBioSurvey();

        Label label = BiologicalSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
        if (label != null)
        {
            label.Text = "The form has been saved and completed successfully.";
        }

        SetupBioSurvey();


    }

    protected void BackSurvey_Click(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    private void SaveCompleteFragSurvey()
    {
        QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM fragKit;

        if (_activity.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs.Count > 0)
        {

            fragKit = _activity.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs.First();

            SaveFragQuestionnaire(ref fragKit);

        }
        else
        {
            fragKit = new QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM();

            SaveFragQuestionnaire(ref fragKit);

            fragKit.WKF_CASE_ACTIVITY_ID = _activity.WKF_CASE_ACTIVITY_ID;
            _activity.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs.Add(fragKit);
        }
        //set questionnaire in-process status

        _manager.Update(_activity);

        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        FormViewBreadCrumb.DataBind();
    }



    private void SaveCompleteBioSurvey()
    {
        QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT bioKit;

        if (_activity.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.Count > 0)
        {

            bioKit = _activity.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.First();

            SaveQuestionnaire(ref bioKit);

        }
        else
        {
            bioKit = new QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT();

            SaveQuestionnaire(ref bioKit);

            bioKit.WKF_CASE_ACTIVITY_ID = _activity.WKF_CASE_ACTIVITY_ID;
            _activity.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.Add(bioKit);
        }
        //set questionnaire in-process status


        _manager.Update(_activity);
        //getRefreshSurvey(_activity.WKF_CASE_ACTIVITY_ID);
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        //refresh bread crumb status onn update
        FormViewBreadCrumb.DataBind();

    }
    private void LoadDropDownData()
    {
        //bio 
        if (_activity.WKF_CASE.STD_WKFCASETYPE_ID == 3)
        {
            //service branches
            //SBNamesListBox.Items.Clear();
            //SBNamesListBox.Items.Add(new ListItem("(Please select branch)", "0"));
            //SBNamesListBox.Items.AddRange(DropDownLists.GetServiceBranchList().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());


            //ILListBox.Items.Clear();
            //ILListBox.Items.Add(new ListItem("(Please select location)", "0"));
            //ILListBox.Items.AddRange(DropDownLists.GetInjuryLocationList().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());

            ReferralSourceListBox.Items.Clear();
            ReferralSourceListBox.Items.Add(new ListItem("(Please select referral source)", "0"));
            ReferralSourceListBox.Items.AddRange(DropDownLists.GetVAMCReferralList().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());

            //FacilityListBox.Items.Clear();
            //FacilityListBox.Items.Add(new ListItem("======Please select facility======", "0"));
            //FacilityListBox.Items.AddRange(DropDownLists.GetTreatmentFacilitiesList().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());
            //VAMCFacilityNameList.DataBind();
            DaysListBox.Items.Clear();
            DaysListBox.Items.AddRange(DropDownLists.GetMonthDays().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());

            MonthsListBox.Items.Clear();
            MonthsListBox.Items.AddRange(DropDownLists.GetMonthNames().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());

        }
        else //frag questionnaire
        {
            FragILListBox.Items.Clear();
            FragILListBox.Items.Add(new ListItem("(Please select location)", "0"));
            FragILListBox.Items.AddRange(DropDownLists.GetInjuryLocationList().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());

            VAMCFacilityNameList.Items.Clear();
            VAMCFacilityNameList.Items.Add(new ListItem("(Please select institution)", "0"));
            VAMCFacilityNameList.Items.AddRange(DropDownLists.GetInsitutionList().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());


        }
    }


    private void SetupSavedOrCompleteFragSurvey(QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM kit)
    {

        //if (kit.Date_Lab_Received_Specimen.HasValue)
        //SpecimenReceivedDateBox.Text = kit.Date_Lab_Received_Specimen.Value.ToShortDateString();
        //SpecimenReceivedDate.DateValue = kit.Date_Lab_Received_Specimen.Value.ToShortDateString();

        Frag1LocationTextBox.Text = kit.Fragment_1_Location;

        Frag2LocationTextBox.Text = kit.Fragment_2_Location;

        Frag3LocationTextBox.Text = kit.Fragment_3_Location;

        if (kit.Date_Fragment_Removal.HasValue)
            //FragRemovalDateBox.Text = kit.Date_Fragment_Removal.Value.ToShortDateString();
            FragRemovalDate.DateValue = kit.Date_Fragment_Removal.Value.ToShortDateString();

        if (!String.IsNullOrEmpty(kit.Duty_Location_Injury_Occurred))
            FragILListBox.SelectedIndex = FragILListBox.Items.IndexOf(FragILListBox.Items.FindByText(kit.Duty_Location_Injury_Occurred));

        FragOtherLocationTextBox.Text = kit.Other_Location_Injury_Occurred;

        //VAMCFragFacilityNameTextBox.Text = kit.Name_Referring_VAMC;
        if (kit.Name_Referring_VAMC.NotNullOrEmpty())
            VAMCFacilityNameList.SelectedIndex = VAMCFacilityNameList.Items.IndexOf(VAMCFacilityNameList.Items.FindByText(kit.Name_Referring_VAMC));
        //VAMCFacilityNameList.SelectedValue = VAMCFacilityNameList.Items.FindByValue(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION_ID);     

        VAMCFragAddress1TextBox.Text = kit.Referring_VAMC_Street_Address1;

        VAMCFragAddress2TextBox.Text = kit.Referring_VAMC_Street_Address2;

        VAMCFragAddress3TextBox.Text = kit.Referring_VAMC_Street_Address3;

        VAMCFragCityTextBox.Text = kit.Referring_VAMC_City;

        VAMCFragStateTextBox.Text = kit.Referring_VAMC_State;

        //VAMCFragZipTextBox.Text = kit.Referring_VAMC_ZipPlus4;

        VAMCFragZipTextBox.Text = kit.Referring_VAMC_PostalCode;

        VAMCFragZip4TextBox.Text = kit.Referring_VAMC_ZipPlus4;

        VAMCFragMailStopTextBox.Text = kit.Referring_VAMC_MailCode;

        SurgeonTextBox.Text = kit.Referring_Provider_Name;

        SurgeonPagerTextBox.Text = kit.Provider_Pager_Number;

        SurgeonPhoneTextBox.Text = kit.Provider_Telephone_Number;

        SurgeonFaxTextBox.Text = kit.Provider_Fax_Number;

        FacilityContactNameTextBox.Text = kit.Referring_Facility_Contact_Name;

        FacilityContactPhoneTextBox.Text = kit.Referring_Facility_Contact_Phone;

    }

    private void SetupSavedOrCompleteSurvey(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
    {
        if (!String.IsNullOrEmpty(kit.VAMC_Name))

            VAMCFAcilityNamesListBox.SelectedIndex = VAMCFAcilityNamesListBox.Items.IndexOf(VAMCFAcilityNamesListBox.Items.FindByText(kit.VAMC_Name));

        else

            VAMCFAcilityNamesListBox.SelectedIndex = 0;

        VAMCAddress1TextBox.Text = kit.VAMC_Street_Address1;

        VAMCAddress2TextBox.Text = kit.VAMC_Street_Address2;

        VAMCAddress3TextBox.Text = kit.VAMC_Street_Address3;

        VAMCCityTextBox.Text = kit.VAMC_City;

        VAMCStateTextBox.Text = kit.VAMC_State;

        //VAMCPostalTextBox.Text = kit.VAMC_PostalCiode;
        VAMCZipTextBox.Text = kit.VAMC_PostalCiode;

        VAMCZip4TextBox.Text = kit.VAMC_ZipPlus4;

        if (kit.Form_Complete_Date.HasValue)
        {
            CompletionDateBox.Text = kit.Form_Complete_Date.Value.ToShortDateString();
        }

        if (kit.BRANCH_OF_SERVICE_AIRFORCE == true)
            SBNamesListBox.Items.FindByValue("Air Force").Selected = true;
        if (kit.BRANCH_OF_SERVICE_ARMY == true)
            SBNamesListBox.Items.FindByValue("Army").Selected = true;
        if (kit.BRANCH_OF_SERVICE_MARINES == true)
            SBNamesListBox.Items.FindByValue("Marine Corps").Selected = true;
        if (kit.BRANCH_OF_SERVICE_NATIONALGUARD == true)
            SBNamesListBox.Items.FindByValue("National Guard").Selected = true;
        if (kit.BRANCH_OF_SERVICE_NAVY == true)
            SBNamesListBox.Items.FindByValue("Navy").Selected = true;
        if (kit.BRANCH_OF_SERVICE_RESERVE == true)
            SBNamesListBox.Items.FindByValue("Reserve").Selected = true;

        if (kit.INJURY_GEOGRAPHICAL_LOCATION_AFGHANISTAN == true)
            CheckBoxAfghanistan.Checked = true;

        if (kit.INJURY_GEOGRAPHICAL_LOCATION_IRAQ == true)
            CheckBoxIraq.Checked = true;

        TextBoxIraqCity.Text = kit.Injury_City;

        if (kit.INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION == true)
            CheckBoxOtherCity.Checked = true;

        TextBoxOtherCity.Text = kit.Injury_Geographical_Location_other;

        if (kit.Injury_Day.HasValue)
        {
            if (kit.Injury_Day.Value > 0)
                DaysListBox.SelectedValue = kit.Injury_Day.Value.ToString();
            else
                DaysListBox.SelectedIndex = 0;
        }

        if (kit.Injury_Month.HasValue)
        {
            if (kit.Injury_Month.Value > 0)
                MonthsListBox.SelectedValue = kit.Injury_Month.Value.ToString();
            else
                MonthsListBox.SelectedIndex = 0;
        }

        if (kit.Injury_Year.HasValue)
        {
            InjuryYearTextBox.Text = kit.Injury_Year.Value.ToString();

        }

        if (!String.IsNullOrEmpty(kit.Who_Referred_You))

            ReferralSourceListBox.SelectedIndex = ReferralSourceListBox.Items.IndexOf(ReferralSourceListBox.Items.FindByText(kit.Who_Referred_You));

        else
            ReferralSourceListBox.SelectedIndex = 0;

        OtherReferralTextBox.Text = kit.Who_Referred_You_Other;

        //display indicators
        if (kit.Bullet_Injury_Ind.HasValue)

            BulletInjuryButtonList.SelectedIndex = BulletInjuryButtonList.Items.IndexOf(BulletInjuryButtonList.Items.FindByValue(kit.Bullet_Injury_Ind.Value.ToString()));

        if (kit.Blast_Explosion_Ind.HasValue)

            BlastExplosionButtonList.SelectedIndex = BlastExplosionButtonList.Items.IndexOf(BlastExplosionButtonList.Items.FindByValue(kit.Blast_Explosion_Ind.Value.ToString()));


        DistanceTextBox.Text = kit.Distance_from_Explosion_Meter;

        if (kit.Injured_on_Vehicle_Ind.HasValue)

            VehicleInjuryButtonList.SelectedIndex = VehicleInjuryButtonList.Items.IndexOf(VehicleInjuryButtonList.Items.FindByValue(kit.Injured_on_Vehicle_Ind.Value.ToString()));

        if (kit.Shrapnel_Frag_Bullet_Surgery_Ind.HasValue)

            SurgeryButtonList.SelectedIndex = SurgeryButtonList.Items.IndexOf(SurgeryButtonList.Items.FindByValue(kit.Shrapnel_Frag_Bullet_Surgery_Ind.Value.ToString()));

        if (kit.Send_to_Lab_Analysis_Ind.HasValue)

            AnalysisButtonList.SelectedIndex = AnalysisButtonList.Items.IndexOf(AnalysisButtonList.Items.FindByValue(kit.Send_to_Lab_Analysis_Ind.Value.ToString()));

        if (kit.Fragment_Remains_inPatient_Ind.HasValue)

            FragmentButtonList.SelectedIndex = FragmentButtonList.Items.IndexOf(FragmentButtonList.Items.FindByValue(kit.Fragment_Remains_inPatient_Ind.Value.ToString()));

        CheckBoxInField.Checked = kit.TREATLOCAT_FIELD;
        TextBoxInTheField.Text = kit.TREATLOCAT_FIELD_Where;
        CheckBoxCombatHospital.Checked = kit.TREATLOCAT_SUPPORTHOSP;
        TextBoxCombatHospital.Text = kit.TREATLOCAT_SUPPORTHOSP_Where;
        CheckBoxGermany.Checked = kit.TREATLOCAT_GERMANY;
        CheckBoxUSFacility.Checked = kit.TREATLOCAT_FACILITY;
        TextBoxUSFacility.Text = kit.TREATLOCAT_FACILITY_Where;
        CheckBoxVAMedicalCenter.Checked = kit.TREATLOCAT_MEDCENTER;
        TextBoxVAMedicalCenter.Text = kit.TREATLOCAT_MEDCENTER_Where;

        if (kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG.HasValue)
        {
            if (kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG == true)
            {
                OtherForeignMaterialButtonList.SelectedIndex = 0;
                OtherForeignMaterialDescriptionTextBox.Text = kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC;
                OtherForeignMaterialLocationTextBox.Text = kit.DEVICE_IMPLANTED_LOCATION1;
            }
            else
            {
                OtherForeignMaterialButtonList.SelectedIndex = 1;
            }
        }
        else
        {
            OtherForeignMaterialButtonList.SelectedIndex = 2;
        }

        if (kit.Shrapnel_In_Body_Ind.HasValue)
            UnrelatedShrapnelButtonList.SelectedIndex = UnrelatedShrapnelButtonList.Items.IndexOf(UnrelatedShrapnelButtonList.Items.FindByValue(kit.Shrapnel_In_Body_Ind.Value.ToString()));

        UnrelatedShrapnelDescriptionTextBox.Text = kit.Shrapnel_In_Body_Desc;

        UnrelatedShrapnelLocationTextBox.Text = kit.Shrapnel_In_Body_DescLoca;

        if (kit.Urine_Collection_Ind.HasValue)
            UrineCollectionButtonList.SelectedIndex = UrineCollectionButtonList.Items.IndexOf(UrineCollectionButtonList.Items.FindByValue(kit.Urine_Collection_Ind.Value.ToString()));

        if (kit.Date_Urine_Collected.HasValue)
            CollectionDate.DateValue = kit.Date_Urine_Collected.Value.ToShortDateString();
    }


    private void SetupExplosionCause(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
    {
        if (kit.Injured_by_IED_FLAG.HasValue)
        {
            CheckBoxExplosionCauses.Items.FindByValue("0").Selected = kit.Injured_by_IED_FLAG.Value;
        }

        if (kit.Injured_by_RPG_FLAG.HasValue)
        {
            CheckBoxExplosionCauses.Items.FindByValue("1").Selected = kit.Injured_by_RPG_FLAG.Value;
        }

        if (kit.Injured_by_LandMine_FLAG.HasValue)
        {
            CheckBoxExplosionCauses.Items.FindByValue("2").Selected = kit.Injured_by_LandMine_FLAG.Value;
        }

        if (kit.Injured_by_Grenade_FLAG.HasValue)
        {
            CheckBoxExplosionCauses.Items.FindByValue("3").Selected = kit.Injured_by_Grenade_FLAG.Value;
        }

        if (kit.Injured_by_EnemyFire_FLAG.HasValue)
        {
            CheckBoxExplosionCauses.Items.FindByValue("4").Selected = kit.Injured_by_EnemyFire_FLAG.Value;
        }

        if (kit.Injured_by_FriendlyFire_FLAG.HasValue)
        {
            CheckBoxExplosionCauses.Items.FindByValue("5").Selected = kit.Injured_by_FriendlyFire_FLAG.Value;
        }

        if (kit.Injured_by_UnknownSource_FLAG.HasValue)
        {
            CheckBoxExplosionCauses.Items.FindByValue("6").Selected = kit.Injured_by_UnknownSource_FLAG.Value;
        }

        if (kit.Injured_by_OtherSource_FLAG.HasValue)
        {
            CheckBoxExplosionCauses.Items.FindByValue("7").Selected = kit.Injured_by_OtherSource_FLAG.Value;
            OtherSourceTextBox.Text = kit.Injured_by_OtherSource_Desc;
        }
    }

    private void SaveExplosionCause(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit, bool saveValues)
    {
        kit.Injured_by_IED_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("0").Selected : false;
        kit.Injured_by_RPG_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("1").Selected : false;
        kit.Injured_by_LandMine_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("2").Selected : false;
        kit.Injured_by_Grenade_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("3").Selected : false;
        kit.Injured_by_EnemyFire_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("4").Selected : false;
        kit.Injured_by_FriendlyFire_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("5").Selected : false;
        kit.Injured_by_UnknownSource_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("6").Selected : false;
        kit.Injured_by_OtherSource_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("7").Selected : false;

        if (saveValues && CheckBoxExplosionCauses.Items.FindByValue("7").Selected)
            kit.Injured_by_OtherSource_Desc = OtherSourceTextBox.Text.Trim();
        else
            kit.Injured_by_OtherSource_Desc = "";
    }

    private void SetupBodyPartsCheckList(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
    {
        ListItem item = BodyPartsList.Items.FindByValue("0");
        item.Selected = kit.Injury_Back_Head.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("1");
        item.Selected = kit.Injury_Back_Neck.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("2");
        item.Selected = kit.Injury_Upper_Back.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("3");
        item.Selected = kit.Injury_Lower_Back.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("4");
        item.Selected = kit.Injury_Buttocks.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("5");
        item.Selected = kit.Injury_Front_Head.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("6");
        item.Selected = kit.Injury_Front_Neck.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("7");
        item.Selected = kit.Injury_Chest.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("8");
        item.Selected = kit.Injury_Abdomen.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("9");
        item.Selected = kit.Injury_Groin_Pelvis.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("10");
        item.Selected = kit.Injury_Left_Shoulder.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("11");
        item.Selected = kit.Injury_Left_Upper_Arm.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("12");
        item.Selected = kit.Injury_Left_Hand_Wrist_Fingers.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("13");
        item.Selected = kit.Injury_Left_Upper_Leg_Thigh.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("14");
        item.Selected = kit.Injury_Left_Knee.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("15");
        item.Selected = kit.Injury_Left_Lower_Leg.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("16");
        item.Selected = kit.Injury_Left_Ankle.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("17");
        item.Selected = kit.Injury_Left_Foot_Toes.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("18");
        item.Selected = kit.Injury_Right_Shoulder.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("19");
        item.Selected = kit.Injury_Right_Upper_Arm.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("20");
        item.Selected = kit.Injury_Right_Lower_Arm.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("21");
        item.Selected = kit.Injury_Right_Hand_Wrist_Fingers.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("22");
        item.Selected = kit.Injury_Right_Upper_Leg_Thigh.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("23");
        item.Selected = kit.Injury_Right_Knee.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("24");
        item.Selected = kit.Injury_Right_Lower_Leg.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("25");
        item.Selected = kit.Injury_Right_Ankle.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("26");
        item.Selected = kit.Injury_Right_Foot_Toes.GetValueOrDefault();

        item = BodyPartsList.Items.FindByValue("27");
        item.Selected = kit.Injury_Left_Lower_Arm.GetValueOrDefault();
    }


    private void SetupTreatmentFacilitiesCheckList(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
    {
        //TreatmentLocationsList.Items.FindByValue("0").Selected = kit.TREATLOCAT_FIELD;
        //TreatmentLocationsList.Items.FindByValue("1").Selected = kit.TREATLOCAT_SUPPORTHOSP;
        //TreatmentLocationsList.Items.FindByValue("2").Selected = kit.TREATLOCAT_GERMANY;
        //TreatmentLocationsList.Items.FindByValue("3").Selected = kit.TREATLOCAT_FACILITY;
        //TreatmentLocationsList.Items.FindByValue("4").Selected = kit.TREATLOCAT_MEDCENTER;  


    }
    private void SetupBodyFragmentsCheckList(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
    {
        ListItem item = FragmentLocationsList.Items.FindByValue("0");
        item.Selected = kit.Remain_in_Back_Head.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("1");
        item.Selected = kit.Remain_in_Back_Neck.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("2");
        item.Selected = kit.Remain_in_Upper_Back.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("3");
        item.Selected = kit.Remain_in_Lower_Back.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("4");
        item.Selected = kit.Remain_in_Buttocks.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("5");
        item.Selected = kit.Remain_in_Front_Head.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("6");
        item.Selected = kit.Remain_in_Front_Neck.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("7");
        item.Selected = kit.Remain_in_Chest.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("8");
        item.Selected = kit.Remain_in_Abdomen.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("9");
        item.Selected = kit.Remain_in_Groin_Pelvis.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("10");
        item.Selected = kit.Remain_in_Left_Shoulder.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("11");
        item.Selected = kit.Remain_in_Left_Upper_Arm.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("12");
        item.Selected = kit.Remain_in_Left_Hand_Wrist_Fingers.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("13");
        item.Selected = kit.Remain_in_Left_Upper_Leg_Thigh.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("14");
        item.Selected = kit.Remain_in_Left_Knee.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("15");
        item.Selected = kit.Remain_in_Left_Lower_Leg.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("16");
        item.Selected = kit.Remain_in_Left_Ankle.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("17");
        item.Selected = kit.Remain_in_Left_Foot_Toes.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("18");
        item.Selected = kit.Remain_in_Right_Shoulder.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("19");
        item.Selected = kit.Remain_in_Right_Upper_Arm.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("20");
        item.Selected = kit.Remain_in_Right_Lower_Arm.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("21");
        item.Selected = kit.Remain_in_Right_Hand_Wrist_Fingers.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("22");
        item.Selected = kit.Remain_in_Right_Upper_Leg_Thigh.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("23");
        item.Selected = kit.Remain_in_Right_Knee.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("24");
        item.Selected = kit.Remain_in_Right_Lower_Leg.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("25");
        item.Selected = kit.Remain_in_Right_Ankle.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("26");
        item.Selected = kit.Remain_in_Right_Foot_Toes.GetValueOrDefault();

        item = FragmentLocationsList.Items.FindByValue("27");
        item.Selected = kit.Remain_in_Left_Lower_Arm.GetValueOrDefault();

    }

    private void SaveFragQuestionnaire(ref QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM kit)
    {
        kit.Fragment_1_Location = Frag1LocationTextBox.Text.Trim();

        kit.Fragment_2_Location = Frag2LocationTextBox.Text.Trim();

        kit.Fragment_3_Location = Frag3LocationTextBox.Text.Trim();

        kit.Date_Fragment_Removal = Helpers.ConvertStringToNullable<DateTime>(FragRemovalDate.DateValue.Trim());

        if (FragILListBox.SelectedIndex > 0)
            kit.Duty_Location_Injury_Occurred = FragILListBox.SelectedItem.Text.Trim();

        kit.Other_Location_Injury_Occurred = FragOtherLocationTextBox.Text.Trim();

        kit.Name_Referring_VAMC = VAMCFacilityNameList.SelectedItem.Text;

        kit.Referring_VAMC_Street_Address1 = VAMCFragAddress1TextBox.Text.Trim();

        kit.Referring_VAMC_Street_Address2 = VAMCFragAddress2TextBox.Text.Trim();

        kit.Referring_VAMC_Street_Address3 = VAMCFragAddress3TextBox.Text.Trim();

        kit.Referring_VAMC_City = VAMCFragCityTextBox.Text.Trim();

        kit.Referring_VAMC_State = VAMCFragStateTextBox.Text.Trim();

        kit.Referring_VAMC_PostalCode = VAMCFragZipTextBox.Text.Trim();

        kit.Referring_VAMC_ZipPlus4 = VAMCFragZip4TextBox.Text.Trim();

        kit.Referring_VAMC_MailCode = VAMCFragMailStopTextBox.Text.Trim();

        kit.Referring_Provider_Name = SurgeonTextBox.Text.Trim();

        kit.Provider_Pager_Number = SurgeonPagerTextBox.Text.Trim();

        kit.Provider_Telephone_Number = SurgeonPhoneTextBox.Text.Trim();

        kit.Provider_Fax_Number = SurgeonFaxTextBox.Text.Trim();

        kit.Referring_Facility_Contact_Name = FacilityContactNameTextBox.Text.Trim();

        kit.Referring_Facility_Contact_Phone = FacilityContactPhoneTextBox.Text.Trim();

    }
    private void SaveQuestionnaire(ref QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
    {


        //kit.TREATLOCAT_FIELD_Where = InTheFieldLocationTextBox.Text.Trim() ;
        //kit.TREATLOCAT_SUPPORTHOSP_Where = CombatSupportLocationTextBox.Text.Trim() ;
        //kit.TREATLOCAT_FACILITY_Where = TreatmentFacilityLocationTextBox.Text.Trim()  ;
        //kit.TREATLOCAT_MEDCENTER_Where = VAMCLocationTextBox.Text.Trim()  ;

        //kit.VAMC_Name = VAMCNameTextBox.Text.Trim();

        if (VAMCFAcilityNamesListBox.SelectedIndex > 0)

            kit.VAMC_Name = VAMCFAcilityNamesListBox.SelectedItem.Text;
        else
            kit.VAMC_Name = "";

        kit.VAMC_Street_Address1 = VAMCAddress1TextBox.Text.Trim();

        kit.VAMC_Street_Address2 = VAMCAddress2TextBox.Text.Trim();

        kit.VAMC_Street_Address3 = VAMCAddress3TextBox.Text.Trim();

        kit.VAMC_City = VAMCCityTextBox.Text.Trim();

        kit.VAMC_State = VAMCStateTextBox.Text.Trim();

        kit.VAMC_PostalCiode = VAMCZipTextBox.Text.Trim();

        kit.VAMC_ZipPlus4 = VAMCZip4TextBox.Text.Trim();

        kit.Form_Complete_Date = Helpers.ConvertStringToNullable<DateTime>(CompletionDateBox.Text);

        //if ( SBNamesListBox.SelectedIndex > 0)

        //    kit.Branch_of_Services = SBNamesListBox.SelectedItem.Text; 


        kit.BRANCH_OF_SERVICE_AIRFORCE = SBNamesListBox.Items.FindByValue("Air Force").Selected;
        kit.BRANCH_OF_SERVICE_ARMY = SBNamesListBox.Items.FindByValue("Army").Selected;
        kit.BRANCH_OF_SERVICE_MARINES = SBNamesListBox.Items.FindByValue("Marine Corps").Selected;
        kit.BRANCH_OF_SERVICE_NATIONALGUARD = SBNamesListBox.Items.FindByValue("National Guard").Selected;
        kit.BRANCH_OF_SERVICE_NAVY = SBNamesListBox.Items.FindByValue("Navy").Selected;
        kit.BRANCH_OF_SERVICE_RESERVE = SBNamesListBox.Items.FindByValue("Reserve").Selected;

        kit.INJURY_GEOGRAPHICAL_LOCATION_AFGHANISTAN = CheckBoxAfghanistan.Checked;

        kit.INJURY_GEOGRAPHICAL_LOCATION_IRAQ = CheckBoxIraq.Checked;
        kit.Injury_City = CheckBoxIraq.Checked ? TextBoxIraqCity.Text : "";

        kit.INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION = CheckBoxOtherCity.Checked;
        kit.Injury_Geographical_Location_other = CheckBoxOtherCity.Checked ? TextBoxOtherCity.Text.Trim() : "";

        kit.Injury_Day = Helpers.ConvertStringToNullable<int>(DaysListBox.SelectedValue);

        kit.Injury_Month = Helpers.ConvertStringToNullable<int>(MonthsListBox.SelectedValue);

        kit.Injury_Year = Helpers.ConvertStringToNullable<int>(InjuryYearTextBox.Text.Trim());

        if (ReferralSourceListBox.SelectedIndex > 0)

            kit.Who_Referred_You = ReferralSourceListBox.SelectedItem.Text;

        kit.Who_Referred_You_Other = OtherReferralTextBox.Text.Trim();

        //save indicators if they set in the UI

        if (BulletInjuryButtonList.SelectedIndex > -1)

            kit.Bullet_Injury_Ind = Helpers.ConvertStringToNullable<char>(BulletInjuryButtonList.SelectedValue);

        if (BlastExplosionButtonList.SelectedIndex == 0)
        {
            kit.Blast_Explosion_Ind = Helpers.ConvertStringToNullable<char>(BlastExplosionButtonList.SelectedValue);
            kit.Distance_from_Explosion_Meter = DistanceTextBox.Text.Trim();

            if (VehicleInjuryButtonList.SelectedIndex > -1)
                kit.Injured_on_Vehicle_Ind = Helpers.ConvertStringToNullable<char>(VehicleInjuryButtonList.SelectedValue);

            SaveExplosionCause(kit, true);
        }
        else
        {
            if (BlastExplosionButtonList.SelectedIndex > -1)
                kit.Blast_Explosion_Ind = Helpers.ConvertStringToNullable<char>(BlastExplosionButtonList.SelectedValue);
            else
                kit.Blast_Explosion_Ind = 'R';

            kit.Distance_from_Explosion_Meter = "";
            kit.Injured_on_Vehicle_Ind = 'R';

            SaveExplosionCause(kit, false);
        }

        if (SurgeryButtonList.SelectedIndex == 0)  // Yes
        {
            kit.Shrapnel_Frag_Bullet_Surgery_Ind = Helpers.ConvertStringToNullable<char>(SurgeryButtonList.SelectedValue);

            if (AnalysisButtonList.SelectedIndex > -1) // Set if there's a selection, otherwise set to Not Recorded
                kit.Send_to_Lab_Analysis_Ind = Helpers.ConvertStringToNullable<char>(AnalysisButtonList.SelectedValue);
            else
                kit.Send_to_Lab_Analysis_Ind = 'R';
        }
        else
        {
            if (SurgeryButtonList.SelectedIndex > -1)
                kit.Shrapnel_Frag_Bullet_Surgery_Ind = Helpers.ConvertStringToNullable<char>(SurgeryButtonList.SelectedValue);
            else
                kit.Shrapnel_Frag_Bullet_Surgery_Ind = 'R';

            // Since the prev selection isn't Yes, set this to Not Recorded
            kit.Send_to_Lab_Analysis_Ind = 'R';
        }

        if (FragmentButtonList.SelectedValue == "Y")
        {
            kit.Fragment_Remains_inPatient_Ind = Helpers.ConvertStringToNullable<char>(FragmentButtonList.SelectedValue);
            SaveFragments(kit, true);
        }
        else
        {
            if (FragmentButtonList.SelectedIndex > -1)
                kit.Fragment_Remains_inPatient_Ind = Helpers.ConvertStringToNullable<char>(FragmentButtonList.SelectedValue);
            SaveFragments(kit, false);
        }

        //some more indicators

        switch (OtherForeignMaterialButtonList.SelectedIndex)
        {
            case -1:
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG = null;
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC = "";
                kit.DEVICE_IMPLANTED_LOCATION1 = "";
                break;
            case 0:
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG = true;
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC = OtherForeignMaterialDescriptionTextBox.Text.Trim();
                kit.DEVICE_IMPLANTED_LOCATION1 = OtherForeignMaterialLocationTextBox.Text.Trim();
                break;
            case 1:
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG = false;
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC = "";
                kit.DEVICE_IMPLANTED_LOCATION1 = "";
                break;
            case 2:
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG = null;
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC = "";
                kit.DEVICE_IMPLANTED_LOCATION1 = "";
                break;
        }

        switch (UnrelatedShrapnelButtonList.SelectedIndex)
        {
            case -1:
                kit.Shrapnel_In_Body_Ind = null;
                kit.Shrapnel_In_Body_Desc = "";
                kit.Shrapnel_In_Body_DescLoca = "";
                break;
            case 0:
                kit.Shrapnel_In_Body_Ind = 'Y';
                kit.Shrapnel_In_Body_Desc = UnrelatedShrapnelDescriptionTextBox.Text.Trim();
                kit.Shrapnel_In_Body_DescLoca = UnrelatedShrapnelLocationTextBox.Text.Trim();
                break;
            case 1:
                kit.Shrapnel_In_Body_Ind = 'N';
                kit.Shrapnel_In_Body_Desc = "";
                kit.Shrapnel_In_Body_DescLoca = "";
                break;
            case 2:
                kit.Shrapnel_In_Body_Ind = 'R';
                kit.Shrapnel_In_Body_Desc = "";
                kit.Shrapnel_In_Body_DescLoca = "";
                break;
        }





        switch (UrineCollectionButtonList.SelectedIndex)
        {
            case -1:
                kit.Urine_Collection_Ind = null;
                kit.Date_Urine_Collected = null;
                break;
            case 0:
                kit.Urine_Collection_Ind = 'Y';
                kit.Date_Urine_Collected = Helpers.ConvertStringToNullable<DateTime>(CollectionDate.DateValue.Trim());
                break;
            case 1:
                kit.Urine_Collection_Ind = 'N';
                kit.Date_Urine_Collected = null;
                break;
            case 2:
                kit.Urine_Collection_Ind = 'R';
                kit.Date_Urine_Collected = null;
                break;
        }

        if (UrineCollectionButtonList.SelectedIndex > -1)

            kit.Urine_Collection_Ind = Helpers.ConvertStringToNullable<char>(UrineCollectionButtonList.SelectedValue);

        kit.Date_Urine_Collected = Helpers.ConvertStringToNullable<DateTime>(CollectionDate.DateValue.Trim());

        // Always set the 2009 form indicator when saving this version

        kit.FORM_2009_FLAG = true;
        kit.FORM_2012_FLAG = false;

        SaveBodyParts(kit);
        //SaveFragments(kit);
        SaveTreatmentFacilities(kit);
    }

    private void SaveTreatmentFacilities(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
    {
        kit.TREATLOCAT_FIELD = CheckBoxInField.Checked;
        kit.TREATLOCAT_FIELD_Where = CheckBoxInField.Checked ? TextBoxInTheField.Text.Trim() : "";

        kit.TREATLOCAT_SUPPORTHOSP = CheckBoxCombatHospital.Checked;
        kit.TREATLOCAT_SUPPORTHOSP_Where = CheckBoxCombatHospital.Checked ? TextBoxCombatHospital.Text.Trim() : "";

        kit.TREATLOCAT_GERMANY = CheckBoxGermany.Checked;

        kit.TREATLOCAT_FACILITY = CheckBoxUSFacility.Checked;
        kit.TREATLOCAT_FACILITY_Where = CheckBoxUSFacility.Checked ? TextBoxUSFacility.Text.Trim() : "";

        kit.TREATLOCAT_MEDCENTER = CheckBoxVAMedicalCenter.Checked;
        kit.TREATLOCAT_MEDCENTER_Where = CheckBoxVAMedicalCenter.Checked ? TextBoxVAMedicalCenter.Text.Trim() : "";
    }

    private void SaveBodyParts(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
    {
        ListItem item = BodyPartsList.Items.FindByValue("0");
        kit.Injury_Back_Head = item.Selected;

        item = BodyPartsList.Items.FindByValue("1");
        kit.Injury_Back_Neck = item.Selected;

        item = BodyPartsList.Items.FindByValue("2");
        kit.Injury_Upper_Back = item.Selected;

        item = BodyPartsList.Items.FindByValue("3");
        kit.Injury_Lower_Back = item.Selected;

        item = BodyPartsList.Items.FindByValue("4");
        kit.Injury_Buttocks = item.Selected;

        item = BodyPartsList.Items.FindByValue("5");
        kit.Injury_Front_Head = item.Selected;

        item = BodyPartsList.Items.FindByValue("6");
        kit.Injury_Front_Neck = item.Selected;

        item = BodyPartsList.Items.FindByValue("7");
        kit.Injury_Chest = item.Selected;

        item = BodyPartsList.Items.FindByValue("8");
        kit.Injury_Abdomen = item.Selected;

        item = BodyPartsList.Items.FindByValue("9");
        kit.Injury_Groin_Pelvis = item.Selected;

        item = BodyPartsList.Items.FindByValue("10");
        kit.Injury_Left_Shoulder = item.Selected;

        item = BodyPartsList.Items.FindByValue("11");
        kit.Injury_Left_Upper_Arm = item.Selected;

        item = BodyPartsList.Items.FindByValue("12");
        kit.Injury_Left_Hand_Wrist_Fingers = item.Selected;

        item = BodyPartsList.Items.FindByValue("13");
        kit.Injury_Left_Upper_Leg_Thigh = item.Selected;

        item = BodyPartsList.Items.FindByValue("14");
        kit.Injury_Left_Knee = item.Selected;

        item = BodyPartsList.Items.FindByValue("15");
        kit.Injury_Left_Lower_Leg = item.Selected;

        item = BodyPartsList.Items.FindByValue("16");
        kit.Injury_Left_Ankle = item.Selected;

        item = BodyPartsList.Items.FindByValue("17");
        kit.Injury_Left_Foot_Toes = item.Selected;

        item = BodyPartsList.Items.FindByValue("18");
        kit.Injury_Right_Shoulder = item.Selected;

        item = BodyPartsList.Items.FindByValue("19");
        kit.Injury_Right_Upper_Arm = item.Selected;

        item = BodyPartsList.Items.FindByValue("20");
        kit.Injury_Right_Lower_Arm = item.Selected;

        item = BodyPartsList.Items.FindByValue("21");
        kit.Injury_Right_Hand_Wrist_Fingers = item.Selected;

        item = BodyPartsList.Items.FindByValue("22");
        kit.Injury_Right_Upper_Leg_Thigh = item.Selected;

        item = BodyPartsList.Items.FindByValue("23");
        kit.Injury_Right_Knee = item.Selected;

        item = BodyPartsList.Items.FindByValue("24");
        kit.Injury_Right_Lower_Leg = item.Selected;

        item = BodyPartsList.Items.FindByValue("25");
        kit.Injury_Right_Ankle = item.Selected;

        item = BodyPartsList.Items.FindByValue("26");
        kit.Injury_Right_Foot_Toes = item.Selected;

        item = BodyPartsList.Items.FindByValue("27");
        kit.Injury_Left_Lower_Arm = item.Selected;

    }

    private void SaveFragments(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit, bool saveValues)
    {
        if (saveValues)
        {
            ListItem item = FragmentLocationsList.Items.FindByValue("0");
            kit.Remain_in_Back_Head = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("1");
            kit.Remain_in_Back_Neck = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("2");
            kit.Remain_in_Upper_Back = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("3");
            kit.Remain_in_Lower_Back = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("4");
            kit.Remain_in_Buttocks = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("5");
            kit.Remain_in_Front_Head = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("6");
            kit.Remain_in_Front_Neck = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("7");
            kit.Remain_in_Chest = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("8");
            kit.Remain_in_Abdomen = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("9");
            kit.Remain_in_Groin_Pelvis = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("10");
            kit.Remain_in_Left_Shoulder = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("11");
            kit.Remain_in_Left_Upper_Arm = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("12");
            kit.Remain_in_Left_Hand_Wrist_Fingers = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("13");
            kit.Remain_in_Left_Upper_Leg_Thigh = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("14");
            kit.Remain_in_Left_Knee = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("15");
            kit.Remain_in_Left_Lower_Leg = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("16");
            kit.Remain_in_Left_Ankle = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("17");
            kit.Remain_in_Left_Foot_Toes = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("18");
            kit.Remain_in_Right_Shoulder = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("19");
            kit.Remain_in_Right_Upper_Arm = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("20");
            kit.Remain_in_Right_Lower_Arm = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("21");
            kit.Remain_in_Right_Hand_Wrist_Fingers = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("22");
            kit.Remain_in_Right_Upper_Leg_Thigh = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("23");
            kit.Remain_in_Right_Knee = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("24");
            kit.Remain_in_Right_Lower_Leg = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("25");
            kit.Remain_in_Right_Ankle = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("26");
            kit.Remain_in_Right_Foot_Toes = item.Selected;

            item = FragmentLocationsList.Items.FindByValue("27");
            kit.Remain_in_Left_Lower_Arm = item.Selected;
        }
        else
        {
            kit.Remain_in_Back_Head = false;
            kit.Remain_in_Back_Neck = false;
            kit.Remain_in_Upper_Back = false;
            kit.Remain_in_Lower_Back = false;
            kit.Remain_in_Buttocks = false;
            kit.Remain_in_Front_Head = false;
            kit.Remain_in_Front_Neck = false;
            kit.Remain_in_Chest = false;
            kit.Remain_in_Abdomen = false;
            kit.Remain_in_Groin_Pelvis = false;
            kit.Remain_in_Left_Shoulder = false;
            kit.Remain_in_Left_Upper_Arm = false;
            kit.Remain_in_Left_Hand_Wrist_Fingers = false;
            kit.Remain_in_Left_Upper_Leg_Thigh = false;
            kit.Remain_in_Left_Knee = false;
            kit.Remain_in_Left_Lower_Leg = false;
            kit.Remain_in_Left_Ankle = false;
            kit.Remain_in_Left_Foot_Toes = false;
            kit.Remain_in_Right_Shoulder = false;
            kit.Remain_in_Right_Upper_Arm = false;
            kit.Remain_in_Right_Lower_Arm = false;
            kit.Remain_in_Right_Hand_Wrist_Fingers = false;
            kit.Remain_in_Right_Upper_Leg_Thigh = false;
            kit.Remain_in_Right_Knee = false;
            kit.Remain_in_Right_Lower_Leg = false;
            kit.Remain_in_Right_Ankle = false;
            kit.Remain_in_Right_Foot_Toes = false;
            kit.Remain_in_Left_Lower_Arm = false;
        }
    }


    protected void DropDownDaysDataBound(object sender, EventArgs e)
    {
        DaysListBox.Items.Insert(0, new ListItem("(unknown)", "0"));
    }

    protected void DropDownMonthsDataBound(object sender, EventArgs e)
    {
        MonthsListBox.Items.Insert(0, new ListItem("(unknown)", "0"));
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "New";
    }

    public override string AppObjectCode()
    {
        return "EFR_QUESTIONNAIRE";
    }


}
